﻿using System.Net;
using System.Collections.Specialized;
using System.IO;
using System.Text;

namespace PerformanceTesting
{
    public class SimpleHttpWebRequest
    {
        private HttpWebRequest request;
        public HttpWebRequest Request { get { return request; } }

        public SimpleHttpWebRequest(string address, CookieContainer cookieJar) 
        {
            request = (HttpWebRequest)WebRequest.Create(address);
            request.Timeout = Utils.Timeout;
            request.AllowAutoRedirect = false;
            request.CookieContainer = cookieJar;
            request.KeepAlive = false;
        }

        public SimpleHttpWebRequest(string address, NameValueCollection uriData, CookieContainer cookieJar) :
            this(address + uriData.ToUriData(), cookieJar)
        {
        }

        public HttpWebResponse Post(NameValueCollection formData) 
        {
            byte[] byteArray = Encoding.UTF8.GetBytes(formData.ToPostData());
            
            request.Method = "POST";
            request.ContentType = "application/x-www-form-urlencoded";
            request.ContentLength = byteArray.Length;

            Stream dataStream = request.GetRequestStream();
            dataStream.Write(byteArray, 0, byteArray.Length);
            dataStream.Close();

            return (HttpWebResponse)request.GetResponse();
        }

        public HttpWebResponse Get() 
        {
            request.Method = "GET";
            return (HttpWebResponse)request.GetResponse();
        }
    }
}
